--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A game object which holds information about body parts.
--- @class tes3bodyPartManager
--- @field animationPhase number *Read-only*. 
--- @field attachNodes tes3bodyPartManagerAttachNode[] *Read-only*. An array-style table with access to the reference's attach node objects.
--- 
--- !!! note
--- 	This array is 1-indexed. The array indices correspond to the [`tes3.bodyPartAttachment`](https://mwse.github.io/MWSE/references/body-part-attachments/) table plus 1 to account for Lua's 1-based array indexing. In other words `bodyPartManager.attachNodes[tes3.bodyPartAttachment.leftHand + 1]` returns the `tes3bodyPartManagerAttachNode` object corresponding to the left hand.
--- 
--- 	Prefer using [`getAttachNode`](https://mwse.github.io/MWSE/types/tes3bodyPartManager/#getattachnode) instead to avoid confusion with the 1-based indexing.
--- 
--- @field reference tes3reference *Read-only*. The access to the reference this body part manager operates for.
tes3bodyPartManager = {}

--- The method fetches the active body part at a given layer and position. This gives access to the associated scene node, equipped item, and base body part.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/types/tes3bodyPartManager/#getactivebodypart).
--- @param layer tes3.activeBodyPartLayer A value from [`tes3.activeBodyPartLayer`](https://mwse.github.io/MWSE/references/active-body-part-layers/) namespace.
--- @param index tes3.activeBodyPart A value from [`tes3.activeBodyPart`](https://mwse.github.io/MWSE/references/active-body-parts/) namespace.
--- @return tes3bodyPartManagerActiveBodyPart result No description yet available.
function tes3bodyPartManager:getActiveBodyPart(layer, index) end

--- The method fetches active body part of a actor for the given item.
--- @param item tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon The item to fetch the active body part for.
--- @return tes3bodyPartManagerActiveBodyPart result No description yet available.
function tes3bodyPartManager:getActiveBodyPartForItem(item) end

--- Fetches the requested attach node.
--- @param index tes3.bodyPartAttachment A value from [`tes3.bodyPartAttachment`](https://mwse.github.io/MWSE/references/body-part-attachments/) namespace.
--- @return tes3bodyPartManagerAttachNode result No description yet available.
function tes3bodyPartManager:getAttachNode(index) end

--- Removes an active body part and optionally sets override data that can be used prevent other items using the same location.
--- @param layer tes3.activeBodyPartLayer A value from [`tes3.activeBodyPartLayer`](https://mwse.github.io/MWSE/references/active-body-part-layers/) namespace.
--- @param index tes3.activeBodyPart A value from [`tes3.activeBodyPart`](https://mwse.github.io/MWSE/references/active-body-parts/) namespace.
--- @param setOverride? boolean *Default*: `true`. A flag which controls whether the override data should be written.
--- @param overrideData? number *Default*: `0`. Use -1 to prevent other items from appearing in the same location.
function tes3bodyPartManager:removeActiveBodyPart(layer, index, setOverride, overrideData) end

--- The method removes all currently equipped layers from the actor.
function tes3bodyPartManager:removeEquippedLayers() end

--- The method sets a new body part for a given object.
--- @param item tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon The item that the body part is from.
--- @param index tes3.activeBodyPart A value from [`tes3.activeBodyPart`](https://mwse.github.io/MWSE/references/active-body-parts/) namespace.
--- @param bodyPartId string The unique ID of the `tes3bodyPart` object to set as a new body part for given object.
--- @param isFirstPerson? boolean *Default*: `false`. A flag which must be set if the target reference is the first person player.
function tes3bodyPartManager:setBodyPartByIdForObject(item, index, bodyPartId, isFirstPerson) end

--- The method sets an active body part slot with an item and bodyPart. Triggers `bodyPart` event.
--- @param item tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon The item that the body part is from.
--- @param index tes3.activeBodyPart A value from [`tes3.activeBodyPart`](https://mwse.github.io/MWSE/references/active-body-parts/) namespace.
--- @param bodyPart tes3bodyPart The `tes3bodyPart` object to set as a new body part for given object.
--- @param isFirstPerson? boolean *Default*: `false`. A flag which must be set if the target reference is the first person player.
function tes3bodyPartManager:setBodyPartForObject(item, index, bodyPart, isFirstPerson) end

--- The method updates all body parts for a given reference.
--- @param reference tes3reference The reference whose body parts will be updated.
function tes3bodyPartManager:updateForReference(reference) end

